/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.opengl;

import frc.emul.api.persistence.IPersistenceReader;
import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.PersistenceException;
import frc.emul.api.ui.IDisplayContext;
import frc.emul.api.ui.IUIContainer;
import frc.emul.config.Configuration;
import frc.emul.config.data.CfgItemChassis;
import frc.emul.config.data.DevOptions;
import frc.emul.periph.lightpen.ILightpenStateProvider;
import frc.emul.standalone.CrashTracker;
import frc.emul.util.Utils;
import frc.emul.vectrex.swing.UI;
import frc.emul.vectrex.ui.GfxItem;
import frc.emul.vectrex.ui.HeadlessDisplay;
import frc.emul.vectrex.ui.Timing;
import frc.emul.vectrex.ui.opengl.IRenderer;
import frc.emul.vectrex.ui.opengl.JoglContext;
import frc.emul.vectrex.ui.opengl.JoglListenerBlur;
import frc.jogl.tools.FPSUtils;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.List;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Display
extends HeadlessDisplay {
    private static DecimalFormat fmt;
    private static final float FRAME_COUNTER = 30000.0f;
    private final int FRAME_THRESHOLD = 90000;
    private final IRenderer jogl;
    private final JoglContext context;
    private final boolean standalone;
    private Configuration conf;
    private GLAutoDrawable canvas;
    private UI ui;
    private boolean synchronizeWithCanvas = false;
    private boolean ticksDriven;
    private int elapsedCycles;
    private long lastUpdateTagNS;
    private long lastUpdateTagMS;
    private MouseMotionListener motionListener;
    private float dragFromOffsetX;
    private float dragFromOffsetY;
    private int dragFromX;
    private int dragFromY;

    static {
        if (DevOptions.showTimingInfo) {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator('.');
            fmt = (DecimalFormat)NumberFormat.getNumberInstance();
            fmt.setMaximumFractionDigits(2);
            fmt.setMinimumFractionDigits(2);
            fmt.setDecimalFormatSymbols(decimalFormatSymbols);
        }
    }

    public Display(IUIContainer iUIContainer, CrashTracker crashTracker, Configuration configuration, boolean bl) {
        this.conf = configuration;
        this.standalone = iUIContainer == null || iUIContainer.isStandalone();
        this.context = new JoglContext(configuration);
        this.jogl = new JoglListenerBlur(this.context);
        if (bl) {
            this.buildUI(crashTracker, iUIContainer);
        }
    }

    @Override
    public void setLightpen(ILightpenStateProvider iLightpenStateProvider) {
        this.context.setLightpen(iLightpenStateProvider);
    }

    @Override
    public Component getDisplayComponent() {
        return (Component)this.getDrawable();
    }

    @Override
    public Component getEventProducer() {
        return (Component)this.getDrawable();
    }

    @Override
    public IDisplayContext getContext() {
        return this.context;
    }

    @Override
    public void updateRendering() {
        if (this.canvas != null) {
            this.canvas.repaint();
        }
    }

    @Override
    public void takeScreenShot(File file) {
        if (this.jogl.isTakingScreenShot()) {
            JOptionPane.showMessageDialog(this.getDisplayComponent(), "Cannot take another ScreenShot until the previous one is saved.", "ParaJVE - ScreenShot", 2);
        } else if (!this.ui.isPaused()) {
            JOptionPane.showMessageDialog(this.getDisplayComponent(), "A ScreenShot can only be taken when the emulator is paused.", "ParaJVE - ScreenShot", 2);
        } else {
            this.jogl.takeScreenShot(file);
        }
    }

    @Override
    public boolean tick(int n) {
        if (this.ui != null && this.ui.isPaused()) {
            this.setPaused(true);
            this.ui.waitEndOfPause();
            this.setPaused(false);
        }
        this.elapsedCycles += n;
        if (this.elapsedCycles >= 90000) {
            this.ticksDriven = true;
            System.out.println("- Ticks Driven Frame");
        }
        if (this.ticksDriven && this.elapsedCycles >= 30000) {
            this.elapsedCycles = 0;
            this.frameCompleted(-1);
        }
        return true;
    }

    @Override
    protected void switchingBuffers(List<GfxItem> list) {
        this.jogl.setLines(list, this.ticksDriven);
    }

    @Override
    public void frameCompleted(int n) {
        float f = n <= 0 ? 30000.0f : (float)n;
        float f2 = f / 30000.0f;
        float f3 = this.elapsedCycles <= 0 ? 1.0f : (float)this.elapsedCycles / f;
        float f4 = f2 * (DevOptions.ignoreFrameCyclesOverrun ? 1.0f : f3);
        if (DevOptions.showTimingInfo) {
            FPSUtils.timingInfos = String.valueOf(this.elapsedCycles) + " / " + (int)f + " : " + fmt.format(f2) + " * " + fmt.format(f3) + " -> " + fmt.format(f4);
        }
        if (this.elapsedCycles > 0) {
            if (this.ticksDriven) {
                System.out.println("- Timer Driven Frame");
            }
            this.elapsedCycles = 0;
            this.ticksDriven = false;
        }
        super.frameCompleted(n);
        if (this.canvas != null) {
            if (this.synchronizeWithCanvas) {
                this.canvas.display();
            } else {
                this.canvas.repaint();
            }
        }
        if (this.ui == null) {
            return;
        }
        Timing timing = this.ui.getTiming();
        switch (timing.getMethod()) {
            case 1: {
                this.resynch_millis_fixed_delay(timing.getMillisDelay(f4));
                break;
            }
            case 0: {
                if (timing.isNanoResolution()) {
                    this.resynch_nanos_fixed_fps(timing.getNanosDelay(f4));
                    break;
                }
                this.resynch_millis_fixed_fps(timing.getMillisDelay(f4));
                break;
            }
        }
    }

    private void resynch_millis_fixed_delay(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void resynch_millis_fixed_fps(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = this.lastUpdateTagMS + l - l2;
        if (l3 > 1L) {
            l2 += l3;
            try {
                Thread.sleep(l3);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.lastUpdateTagMS = System.currentTimeMillis();
    }

    private void resynch_nanos_fixed_fps(long l) {
        long l2 = System.nanoTime();
        long l3 = this.lastUpdateTagNS + l - l2;
        if (l3 > 1500000L) {
            l2 += l3;
            long l4 = l3 / 1000000L;
            int n = (int)(l3 - l4 * 1000000L);
            try {
                Thread.sleep(l4, n);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.lastUpdateTagNS = System.nanoTime();
    }

    public Configuration getConfig() {
        return this.conf;
    }

    public IRenderer getRenderer() {
        return this.jogl;
    }

    public GLAutoDrawable getDrawable() {
        if (this.canvas == null) {
            try {
                this.initCanvas(!this.standalone);
            }
            catch (Exception exception) {
                System.out.println("*** Error while creating the drawable canvas!");
                exception.printStackTrace(System.out);
            }
        }
        return this.canvas;
    }

    public UI buildUI(CrashTracker crashTracker, IUIContainer iUIContainer) {
        if (this.ui == null) {
            this.ui = new UI(this, this.getConfig(), crashTracker, iUIContainer);
            this.waitForInitialisationCompletion();
        }
        return this.ui;
    }

    public UI getUI() {
        return this.ui;
    }

    public static boolean isSupportedScreenShotFormat(File file) {
        String string = file.getName().toLowerCase();
        return string.endsWith(".bmp") || string.endsWith(".png") || string.endsWith(".jpg");
    }

    public static File getSupportedScreenShotFormat(File file) {
        if (!Display.isSupportedScreenShotFormat(file)) {
            String string = file.getName();
            file = string.indexOf(46) < 0 ? new File(file.getParentFile(), String.valueOf(string) + ".png") : null;
        }
        return file;
    }

    private final void waitForInitialisationCompletion() {
        GLAutoDrawable gLAutoDrawable = this.getDrawable();
        if (!this.jogl.isInitialised()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        while (!this.jogl.isInitialised()) {
            System.out.println("- Forcing GLCanvas refresh");
            gLAutoDrawable.display();
        }
    }

    private final GLCanvas shareCanvasContext(GLCapabilities gLCapabilities) {
        System.out.println("- Sharing GLCanvas context");
        try {
            if (gLCapabilities == null) {
                gLCapabilities = Display.getEmulatorCapabilities();
            }
            GLCanvas gLCanvas = new GLCanvas(gLCapabilities, null, this.getDrawable().getContext(), null);
            JFrame jFrame = new JFrame("ParaJVE JOGL shared context");
            jFrame.setDefaultCloseOperation(0);
            jFrame.getContentPane().add((Component)gLCanvas);
            jFrame.setBounds(0, 0, 1, 1);
            jFrame.setUndecorated(true);
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowOpened(WindowEvent windowEvent) {
                    windowEvent.getWindow().setVisible(false);
                }
            });
            jFrame.setVisible(true);
            return gLCanvas;
        }
        catch (Exception exception) {
            System.err.println("*** Error while sharing the GLCanvas context :");
            exception.printStackTrace(System.err);
            return null;
        }
    }

    private synchronized void initCanvas(boolean bl) {
        if (this.canvas != null) {
            return;
        }
        System.out.println("- Creating GLCanvas");
        GLCapabilities gLCapabilities = Display.getEmulatorCapabilities();
        this.canvas = new GLCanvas(gLCapabilities);
        this.canvas.addGLEventListener((GLEventListener)this.jogl);
        if (Utils.isMacOSX()) {
            this.canvas.addGLEventListener((GLEventListener)new MacOSXFocusGrabber());
        }
        this.canvas.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                float f = mouseWheelEvent.isControlDown() ? 0.002f : 0.02f;
                float f2 = Display.this.context.getChassisZoom();
                float f3 = f2 - f2 * (f * (float)mouseWheelEvent.getWheelRotation());
                Display.this.context.setChassisZoom(f3);
                Display.this.getUI().setChassisZoomFactor(Display.this.context.getChassisZoom(), !mouseWheelEvent.isShiftDown());
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                    Display.this.motionListener = new MouseMotionAdapter(){

                        public void mouseDragged(MouseEvent mouseEvent) {
                            float f = ((Display)(this).Display.this).context.getChassisSettings().zoom;
                            float f2 = Display.this.dragFromOffsetX - 2.0f / (float)Display.this.canvas.getWidth() * (float)(Display.this.dragFromX - mouseEvent.getX()) / f;
                            float f3 = Display.this.dragFromOffsetY + 2.0f / (float)Display.this.canvas.getHeight() * (float)(Display.this.dragFromY - mouseEvent.getY()) / f;
                            Display.this.getUI().setChassisZoomOffsets(f2, f3);
                        }
                    };
                    CfgItemChassis cfgItemChassis = Display.this.context.getChassisSettings();
                    Display.this.dragFromOffsetX = cfgItemChassis.xOffset;
                    Display.this.dragFromOffsetY = cfgItemChassis.yOffset;
                    Display.this.dragFromX = mouseEvent.getX();
                    Display.this.dragFromY = mouseEvent.getY();
                    Display.this.canvas.addMouseMotionListener(Display.this.motionListener);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (Display.this.motionListener != null && SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                    Display.this.canvas.removeMouseMotionListener(Display.this.motionListener);
                    Display.this.motionListener = null;
                }
            }
        });
        if (bl && !DevOptions.disableGLContextSharing) {
            this.shareCanvasContext(gLCapabilities);
        }
        if (DevOptions.openOverlayAdjustmentDialog) {
            this.context.openOverlayAdjustmentDialog(this.canvas);
        }
    }

    protected static final GLCapabilities getEmulatorCapabilities() {
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setRedBits(8);
        gLCapabilities.setBlueBits(8);
        gLCapabilities.setGreenBits(8);
        gLCapabilities.setAlphaBits(8);
        gLCapabilities.setDepthBits(16);
        return gLCapabilities;
    }

    @Override
    public void store(IPersistenceWriter iPersistenceWriter) throws PersistenceException {
        iPersistenceWriter.write(this.jogl);
        super.store(iPersistenceWriter);
        iPersistenceWriter.write(this.ticksDriven);
        iPersistenceWriter.write(this.elapsedCycles);
    }

    @Override
    public void load(IPersistenceReader iPersistenceReader) throws PersistenceException {
        iPersistenceReader.read(this.jogl);
        super.load(iPersistenceReader);
        this.ticksDriven = iPersistenceReader.readBool();
        this.elapsedCycles = iPersistenceReader.readInt();
        this.updateRendering();
    }

    private final class MacOSXFocusGrabber
    implements GLEventListener {
        private int count = 3;

        private MacOSXFocusGrabber() {
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }

        public synchronized void display(GLAutoDrawable gLAutoDrawable) {
            if (this.count-- < 0) {
                gLAutoDrawable.removeGLEventListener((GLEventListener)this);
                if (gLAutoDrawable instanceof GLCanvas) {
                    ((GLCanvas)gLAutoDrawable).requestFocus();
                    ((GLCanvas)gLAutoDrawable).requestFocusInWindow();
                }
            }
        }
    }
}

